/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/

/**
 * \file    aic3106_main.c
 *
 * \brief   Main entry point for the AIC3106 tests
 *
 * This file contains the entry point for configuring and testing the AIC3106 Audio
 * codec on the Base Board.
 *
 * \author  0043
 *
 * \version 01a,19aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "stdio.h"
#include "DM814x_i2c.h"
#include "DM814x_EVM.h"
#include "aic3106.h"

 /*
 *====================
 * Defines
 *====================
 */

/*
 *====================
 * Function implementations
 *====================
 */
/** **************************************************************************
 * \n \brief Routine to test the AIC3106 Audio codec on Base board
 *
 * This routine initializes the AIC3106 Audio Codec on the base board to test
 * various interfaces including the following
 *	(a) Playback on Head-phohne
 *  (b) Playback on Line-Out
 *  (c) Loopback the input on Microphone to head-set.
 *  (d) Loopback the input on Line-In to Line-Out
 *
 * \param u8McaspNum	[IN]	Instance of McASP number
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
void main (void)
{
	STATUS u32RetVal = SUCCESS;
	
	DM814x_EVM_Init ();
	
	u32RetVal = aic3106_tests (2);
	
	if (u32RetVal == SUCCESS)
	{
		printf ("All configuration & Playback/loopback successfully completed.\r\n");
		printf ("However, actual results are to be judged based on the audio \r\n");
		printf (" heard from the head-phone and speakers.\r\n");
	}
	else
	{
		printf ("Some configuration failed.\r\n");
	}
	
	/* Software Breakpoint to Code Composer */
	SW_BREAKPOINT;
	
}
